export declare function coerceArray<T>(input: T[] | null | undefined): T[];
export declare function isNotNullOrUndefined<T>(value: T | undefined | null): value is T;
/**
 * Converts a single value or an array of values to an array of values.
 * @param value a single value or an array of values
 * @returns array of values
 */
export declare function toArray<T>(value: T | T[]): T[];
export declare function deduplicateArray<T>(array: T[]): T[];
