#!/usr/bin/env node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("source-map-support/register");
require("./punycode.cjs");
const instrumentation_1 = require("./instrumentation"); // has to be imported before logger and other libraries which are instrumentalised
const logger_1 = require("./logger");
const proxy_1 = require("./proxy");
const global_1 = require("./workers/global");
/* v8 ignore next 3 -- not easily testable */
process.on('unhandledRejection', (err) => {
    logger_1.logger.error({ err }, 'unhandledRejection');
});
(0, proxy_1.bootstrap)();
// eslint-disable-next-line @typescript-eslint/no-floating-promises
(async () => {
    process.exitCode = await (0, instrumentation_1.instrument)('run', () => (0, global_1.start)());
    await (0, instrumentation_1.shutdown)(); //gracefully shutdown OpenTelemetry
    /* v8 ignore next 3 -- no test required */
    if (process.env.RENOVATE_X_HARD_EXIT) {
        process.exit(process.exitCode);
    }
})();
//# sourceMappingURL=renovate.js.map