"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.api = exports.supportsRanges = exports.urls = exports.displayName = exports.id = void 0;
const logger_1 = require("../../../logger");
const semver_coerced_1 = require("../semver-coerced");
exports.id = 'same-major';
exports.displayName = 'Same Major Versioning';
exports.urls = [];
exports.supportsRanges = false;
/**
 *
 * Converts input to range if it's a version. eg. X.Y.Z -> '>=X.Y.Z <X+1'
 * If the input is already a range, it returns the input.
 */
function massageVersion(input) {
    // istanbul ignore if: same-major versioning should not be used with ranges as it defeats the purpose
    if (!semver_coerced_1.api.isSingleVersion(input)) {
        logger_1.logger.warn({ version: input }, 'Same major versioning expects a single version but got a range. Please switch to a different versioning as this may lead to unexpected behaviour.');
        return input;
    }
    // we are sure to get a major because of the isSingleVersion check
    const major = semver_coerced_1.api.getMajor(input);
    return `>=${input} <${major + 1}`;
}
// for same major versioning one version is greater than the other if its major is greater
function isGreaterThan(version, other) {
    const versionMajor = semver_coerced_1.api.getMajor(version);
    const otherMajor = semver_coerced_1.api.getMajor(other);
    if (!versionMajor || !otherMajor) {
        return false;
    }
    return versionMajor > otherMajor;
}
function matches(version, range) {
    return semver_coerced_1.api.matches(version, massageVersion(range));
}
function getSatisfyingVersion(versions, range) {
    return semver_coerced_1.api.getSatisfyingVersion(versions, massageVersion(range));
}
function minSatisfyingVersion(versions, range) {
    return semver_coerced_1.api.minSatisfyingVersion(versions, massageVersion(range));
}
function isLessThanRange(version, range) {
    return semver_coerced_1.api.isLessThanRange(version, massageVersion(range));
}
exports.api = {
    ...semver_coerced_1.api,
    matches,
    getSatisfyingVersion,
    minSatisfyingVersion,
    isLessThanRange,
    isGreaterThan,
};
exports.default = exports.api;
//# sourceMappingURL=index.js.map