"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const operator_1 = require("../operator");
const range_1 = require("../range");
const version_1 = require("../version");
const replace_1 = require("./replace");
exports.default = ({ range, to }) => {
    const parts = (0, range_1.parseRanges)(range).flatMap((part) => {
        if ((0, range_1.satisfiesRange)(to, part)) {
            return [part];
        }
        const { operator, version: ver, companion } = part;
        switch (operator) {
            // `~>` works as both lower bound and upper bound.
            // We need to decompose it to get wider range.
            case operator_1.PGTE: {
                // Prefer constraints from `>=`
                const baseVersion = companion ? companion.version : ver;
                const limit = (0, version_1.increment)((0, version_1.pgteUpperBound)(ver), to);
                return [
                    { operator: operator_1.GTE, delimiter: ' ', version: baseVersion },
                    { operator: operator_1.LT, delimiter: ' ', version: limit },
                ];
            }
            default:
                return [(0, replace_1.replacePart)(part, to)];
        }
    });
    return (0, range_1.stringifyRanges)(parts);
};
//# sourceMappingURL=widen.js.map