"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ruby_semver_1 = require("@renovatebot/ruby-semver");
const operator_1 = require("../operator");
const range_1 = require("../range");
const version_1 = require("../version");
const replace_1 = require("./replace");
exports.default = ({ range, to }) => {
    const parts = (0, range_1.parseRanges)(range).map((part) => {
        const { operator, version: ver } = part;
        switch (operator) {
            // Update upper bound (`<` and `<=`) ranges only if the new version violates them
            case operator_1.LT:
                return (0, ruby_semver_1.gte)(to, ver) ? (0, replace_1.replacePart)(part, to) : part;
            case operator_1.LTE:
                return (0, ruby_semver_1.gt)(to, ver) ? (0, replace_1.replacePart)(part, to) : part;
            // `~>` ranges.
            case operator_1.PGTE: {
                // Try to add / remove extra `>=` constraint.
                const trimmed = (0, version_1.adapt)(to, ver);
                if ((0, version_1.trimZeroes)(trimmed) === (0, version_1.trimZeroes)(to)) {
                    // E.g. `'~> 5.2', '>= 5.2.0'`. In this case the latter is redundant.
                    return { ...part, version: trimmed, companion: undefined };
                }
                else {
                    // E.g. `'~> 5.2', '>= 5.2.1'`.
                    return {
                        ...part,
                        version: trimmed,
                        companion: { operator: operator_1.GTE, delimiter: ' ', version: to },
                    };
                }
            }
            case operator_1.NOT_EQUAL:
                if ((0, ruby_semver_1.lt)(ver, to)) {
                    // The version to exclude is now out of range.
                    return { ...part, operator: operator_1.GTE, version: to };
                }
                return part;
            default:
                // For `=` and lower bound ranges, always keep it stick to the new version.
                return (0, replace_1.replacePart)(part, to);
        }
    });
    return (0, range_1.stringifyRanges)(parts);
};
//# sourceMappingURL=bump.js.map