"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.api = exports.supportsRanges = exports.urls = exports.displayName = exports.id = void 0;
const regex_1 = require("../../../util/regex");
const generic_1 = require("../generic");
exports.id = 'redhat';
exports.displayName = 'Red Hat';
exports.urls = [];
exports.supportsRanges = false;
const pattern = (0, regex_1.regEx)(/^(?<major>\d+)(?:\.(?<minor>\d+))?(?:\.(?<patch>\d+))?(?:-(?<releaseMajor>\d+)(?:\.(?<releaseMinor>\d+))?)?$/);
class RedhatVersioningApi extends generic_1.GenericVersioningApi {
    _parse(version) {
        const matches = pattern.exec(version)?.groups;
        if (!matches) {
            return null;
        }
        const { major, minor, patch, releaseMajor, releaseMinor } = matches;
        const release = [
            Number.parseInt(major, 10),
            typeof minor === 'undefined' ? 0 : Number.parseInt(minor, 10),
            typeof patch === 'undefined' ? 0 : Number.parseInt(patch, 10),
            typeof releaseMajor === 'undefined'
                ? 0
                : Number.parseInt(releaseMajor, 10),
            typeof releaseMinor === 'undefined'
                ? 0
                : Number.parseInt(releaseMinor, 10),
        ];
        return { release, prerelease: '' };
    }
}
exports.api = new RedhatVersioningApi();
exports.default = exports.api;
//# sourceMappingURL=index.js.map