"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.api = exports.supportsRanges = exports.urls = exports.displayName = exports.id = void 0;
exports.isBreaking = isBreaking;
const pep440_1 = require("../pep440");
const poetry_1 = require("../poetry");
exports.id = 'python';
exports.displayName = 'Python';
exports.urls = [];
exports.supportsRanges = false;
function isLessThanRange(version, range) {
    return poetry_1.api.isValid(range)
        ? poetry_1.api.isLessThanRange(version, range)
        : pep440_1.api.isLessThanRange(version, range);
}
function isValid(input) {
    return poetry_1.api.isValid(input) || pep440_1.api.isValid(input);
}
function matches(version, range) {
    return poetry_1.api.isValid(range)
        ? poetry_1.api.matches(version, range)
        : pep440_1.api.matches(version, range);
}
function getSatisfyingVersion(versions, range) {
    return poetry_1.api.isValid(range)
        ? poetry_1.api.getSatisfyingVersion(versions, range)
        : pep440_1.api.getSatisfyingVersion(versions, range);
}
function minSatisfyingVersion(versions, range) {
    return poetry_1.api.isValid(range)
        ? poetry_1.api.minSatisfyingVersion(versions, range)
        : pep440_1.api.minSatisfyingVersion(versions, range);
}
function getNewValue(newValue) {
    return poetry_1.api.getNewValue(newValue);
}
function subset(subRange, superRange) {
    return poetry_1.api.isValid(subRange) && poetry_1.api.isValid(superRange)
        ? poetry_1.api.subset(subRange, superRange)
        : undefined;
}
function isBreaking(current, version) {
    const currentMajor = poetry_1.api.getMajor(current);
    const currentMinor = poetry_1.api.getMinor(current);
    const newMajor = poetry_1.api.getMajor(version);
    const newMinor = poetry_1.api.getMinor(version);
    return !(currentMajor === newMajor && currentMinor === newMinor);
}
exports.api = {
    ...poetry_1.api,
    getNewValue,
    getSatisfyingVersion,
    isBreaking,
    isLessThanRange,
    isValid,
    matches,
    minSatisfyingVersion,
    subset,
};
exports.default = exports.api;
//# sourceMappingURL=index.js.map