"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractAllParts = extractAllParts;
exports.getParts = getParts;
exports.plusOne = plusOne;
exports.compareIntArray = compareIntArray;
function extractAllParts(version) {
    const parts = version.split('.').map((x) => parseInt(x, 10));
    const ret = [];
    for (const l of parts) {
        if (l < 0 || !isFinite(l)) {
            return null;
        }
        ret.push(l);
    }
    return ret;
}
function getParts(splitOne) {
    const c = extractAllParts(splitOne);
    if (c === null) {
        return null;
    }
    return {
        major: c.slice(0, 2),
        minor: c.slice(2, 3),
        patch: c.slice(3),
    };
}
function plusOne(majorOne) {
    return `${majorOne[0]}.${majorOne[1] + 1}`;
}
function compareIntArray(versionPartsInt, otherPartsInt) {
    for (let i = 0; i < Math.min(versionPartsInt.length, otherPartsInt.length); i++) {
        if (versionPartsInt[i] > otherPartsInt[i]) {
            return 'gt';
        }
        if (versionPartsInt[i] < otherPartsInt[i]) {
            return 'lt';
        }
    }
    if (versionPartsInt.length === otherPartsInt.length) {
        return 'eq';
    }
    if (versionPartsInt.length > otherPartsInt.length) {
        return 'gt';
    }
    return 'lt';
}
//# sourceMappingURL=util.js.map