"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.api = exports.supportsRanges = exports.urls = exports.displayName = exports.id = void 0;
const regex_1 = require("../../../util/regex");
const generic_1 = require("../generic");
exports.id = 'perl';
exports.displayName = 'Perl';
exports.urls = ['https://metacpan.org/pod/version'];
exports.supportsRanges = false;
// https://metacpan.org/pod/version#Decimal-Versions
const decimalVersionPattern = (0, regex_1.regEx)(/^(\d+)\.(\d+(?:_\d+)?)$/);
// https://metacpan.org/pod/version#Dotted-Decimal-Versions
const dottedDecimalVersionPattern = (0, regex_1.regEx)(/^v?(\d+(?:\.\d+)*(?:_\d+)?)$/);
class PerlVersioningApi extends generic_1.GenericVersioningApi {
    _parse(version) {
        return (this._parseDecimalVersion(version) ??
            this._parseDottedDecimalVersion(version));
    }
    _parseDecimalVersion(version) {
        const matches = decimalVersionPattern.exec(version);
        if (!matches) {
            return null;
        }
        const [, intPart, decimalPart] = matches;
        const prerelease = decimalPart.includes('_') ? 'alpha' : '';
        const decimalComponents = decimalPart
            .replace(/_/g, '')
            .match(/.{1,3}/g)
            ?.map((value) => {
            let component = value;
            while (component.length < 3) {
                component += '0';
            }
            return Number.parseInt(component, 10);
        }) ?? /* istanbul ignore next */ [];
        const release = [Number.parseInt(intPart, 10), ...decimalComponents];
        return { release, prerelease };
    }
    _parseDottedDecimalVersion(version) {
        const matches = dottedDecimalVersionPattern.exec(version);
        if (!matches) {
            return null;
        }
        const [, versionValue] = matches;
        const prerelease = versionValue.includes('_') ? 'alpha' : '';
        const release = versionValue.split((0, regex_1.regEx)(/[._]/)).map(Number);
        return { release, prerelease };
    }
}
exports.api = new PerlVersioningApi();
exports.default = exports.api;
//# sourceMappingURL=index.js.map