"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.api = exports.NixPkgsVersioning = exports.supportsRanges = exports.urls = exports.displayName = exports.id = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const regex_1 = require("../regex");
exports.id = 'nixpkgs';
exports.displayName = 'Nixpkgs';
exports.urls = ['https://github.com/NixOS/nixpkgs'];
exports.supportsRanges = false;
class NixPkgsVersioning extends regex_1.RegExpVersioningApi {
    static versionRegex = '^(?<prefix>(nixos|nixpkgs|release))-((?<major>\\d{2})\\.(?<minor>\\d{2})|unstable)(-(?<suffix>(small|aarch64|darwin)))?$';
    constructor() {
        super(NixPkgsVersioning.versionRegex);
    }
    _parse(version) {
        const groups = this._config?.exec(version)?.groups;
        if (!groups) {
            return null;
        }
        const { prefix, major, minor, suffix } = groups;
        const release = [];
        if (major) {
            release.push(Number.parseInt(major, 10));
        }
        if (minor) {
            release.push(Number.parseInt(minor, 10));
        }
        const compatibility = is_1.default.nonEmptyStringAndNotWhitespace(suffix)
            ? `${prefix}-${suffix}`
            : prefix;
        return {
            release,
            compatibility,
        };
    }
    isStable(version) {
        const parsed = this._parse(version);
        return is_1.default.nonEmptyArray(parsed?.release);
    }
    _compare(version, other) {
        const left = this._parse(version);
        const right = this._parse(other);
        // empty version is equal to 'unstable'
        if (is_1.default.emptyArray(left?.release) && is_1.default.emptyArray(right?.release)) {
            return 0;
        }
        if (is_1.default.emptyArray(left?.release)) {
            return 1;
        }
        if (is_1.default.emptyArray(right?.release)) {
            return -1;
        }
        return super._compare(version, other);
    }
}
exports.NixPkgsVersioning = NixPkgsVersioning;
exports.api = NixPkgsVersioning;
exports.default = exports.api;
//# sourceMappingURL=index.js.map