"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.api = exports.supportsRanges = exports.urls = exports.displayName = exports.id = void 0;
exports.isStable = isStable;
const luxon_1 = require("luxon");
const node_1 = require("../node");
const schedule_1 = require("./schedule");
exports.id = 'lambda-node';
exports.displayName = 'Lambda Node.js Runtime';
exports.urls = [];
exports.supportsRanges = false;
function isStable(version) {
    const schedule = (0, schedule_1.findLambdaScheduleForVersion)(version);
    if (schedule === null) {
        return false;
    }
    if (typeof schedule.support === 'string') {
        return luxon_1.DateTime.local() < luxon_1.DateTime.fromISO(schedule.support);
    }
    return true;
}
exports.api = {
    ...node_1.api,
    isStable,
};
exports.default = exports.api;
//# sourceMappingURL=index.js.map