"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.api = exports.KubernetesApiVersioningApi = exports.supportsRanges = exports.urls = exports.displayName = exports.id = void 0;
const regex_1 = require("../regex");
exports.id = 'kubernetes-api';
exports.displayName = 'Kubernetes API';
exports.urls = [
    'https://kubernetes.io/docs/reference/using-api/#api-versioning',
];
exports.supportsRanges = false;
class KubernetesApiVersioningApi extends regex_1.RegExpVersioningApi {
    static versionRegex = '^(?:(?<compatibility>\\S+)/)?v(?<major>\\d+)(?<prerelease>(?:alpha|beta)\\d+)?$';
    constructor() {
        super(KubernetesApiVersioningApi.versionRegex);
    }
}
exports.KubernetesApiVersioningApi = KubernetesApiVersioningApi;
exports.api = new KubernetesApiVersioningApi();
exports.default = exports.api;
//# sourceMappingURL=index.js.map