"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isVersion = exports.api = exports.supportedRangeStrategies = exports.supportsRanges = exports.urls = exports.displayName = exports.id = void 0;
exports.isValid = isValid;
const logger_1 = require("../../../logger");
const common_1 = require("../common");
const npm_1 = require("../npm");
const convertor_1 = require("./convertor");
exports.id = 'hashicorp';
exports.displayName = 'Hashicorp';
exports.urls = [
    'https://www.terraform.io/docs/configuration/terraform.html#specifying-a-required-terraform-version',
];
exports.supportsRanges = true;
exports.supportedRangeStrategies = [
    'bump',
    'widen',
    'pin',
    'replace',
];
function isLessThanRange(version, range) {
    return !!npm_1.api.isLessThanRange?.(version, (0, convertor_1.hashicorp2npm)(range));
}
function isValid(input) {
    if (input) {
        try {
            return npm_1.api.isValid((0, convertor_1.hashicorp2npm)(input));
        }
        catch {
            logger_1.logger.trace({ value: input }, 'Unsupported hashicorp versioning value');
            return false;
        }
    }
    return false;
}
function matches(version, range) {
    const excludedVersions = (0, common_1.getExcludedVersions)(range);
    if (excludedVersions.includes(version)) {
        return false;
    }
    const filteredRange = (0, common_1.getFilteredRange)(range);
    return (isValid(filteredRange) && npm_1.api.matches(version, (0, convertor_1.hashicorp2npm)(filteredRange)));
}
function getSatisfyingVersion(versions, range) {
    const excludedVersions = (0, common_1.getExcludedVersions)(range);
    const filteredRange = (0, common_1.getFilteredRange)(range);
    const filteredVersions = versions.filter((version) => !excludedVersions.includes(version));
    return npm_1.api.getSatisfyingVersion(filteredVersions, (0, convertor_1.hashicorp2npm)(filteredRange));
}
function minSatisfyingVersion(versions, range) {
    const excludedVersions = (0, common_1.getExcludedVersions)(range);
    const filteredRange = (0, common_1.getFilteredRange)(range);
    const filteredVersions = versions.filter((version) => !excludedVersions.includes(version));
    return npm_1.api.minSatisfyingVersion(filteredVersions, (0, convertor_1.hashicorp2npm)(filteredRange));
}
function getNewValue({ currentValue, rangeStrategy, currentVersion, newVersion, }) {
    let npmNewVersion = npm_1.api.getNewValue({
        currentValue: (0, convertor_1.hashicorp2npm)(currentValue),
        rangeStrategy,
        currentVersion,
        newVersion,
    });
    if (npmNewVersion) {
        npmNewVersion = (0, convertor_1.npm2hashicorp)(npmNewVersion);
        if (currentValue.startsWith('v') && !npmNewVersion.startsWith('v')) {
            npmNewVersion = `v${npmNewVersion}`;
        }
    }
    return npmNewVersion;
}
exports.api = {
    ...npm_1.api,
    isLessThanRange,
    isValid,
    matches,
    getSatisfyingVersion,
    minSatisfyingVersion,
    getNewValue,
};
// eslint-disable-next-line @typescript-eslint/unbound-method
exports.isVersion = exports.api.isVersion;
exports.default = exports.api;
//# sourceMappingURL=index.js.map