"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.api = exports.isValid = exports.supportedRangeStrategies = exports.supportsRanges = exports.urls = exports.displayName = exports.id = void 0;
const regex_1 = require("../../../util/regex");
const npm_1 = require("../npm");
exports.id = 'go-mod-directive';
exports.displayName = 'Go Modules Directive';
exports.urls = ['https://go.dev/ref/mod'];
exports.supportsRanges = true;
exports.supportedRangeStrategies = ['bump', 'replace'];
const validRegex = (0, regex_1.regEx)(/^\d+\.\d+(\.\d+)?$/);
function toNpmRange(range) {
    return `^${range}`;
}
function shorten(version) {
    return version.split('.').slice(0, 2).join('.');
}
function getNewValue({ currentValue, rangeStrategy, newVersion, }) {
    if (rangeStrategy === 'bump') {
        if (npm_1.api.matches(newVersion, '>=1.20.0')) {
            return newVersion;
        }
        return shorten(newVersion);
    }
    if (rangeStrategy === 'replace' && !matches(newVersion, currentValue)) {
        return newVersion;
    }
    return currentValue;
}
function getSatisfyingVersion(versions, range) {
    return npm_1.api.getSatisfyingVersion(versions, toNpmRange(range));
}
const isLessThanRange = (version, range) => npm_1.api.isLessThanRange(version, toNpmRange(range));
const isValid = (input) => !!input.match(validRegex);
exports.isValid = isValid;
const matches = (version, range) => npm_1.api.matches(version, toNpmRange(range));
function minSatisfyingVersion(versions, range) {
    return npm_1.api.minSatisfyingVersion(versions, toNpmRange(range));
}
exports.api = {
    ...npm_1.api,
    getNewValue,
    getSatisfyingVersion,
    isLessThanRange,
    isValid: exports.isValid,
    matches,
    minSatisfyingVersion,
};
exports.default = exports.api;
//# sourceMappingURL=index.js.map