"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.api = exports.GlasskubeVersioningApi = exports.supportsRanges = exports.urls = exports.displayName = exports.id = void 0;
const semver_1 = require("semver");
const generic_1 = require("../generic");
exports.id = 'glasskube';
exports.displayName = 'glasskube';
exports.urls = [];
exports.supportsRanges = false;
class GlasskubeVersioningApi extends generic_1.GenericVersioningApi {
    _parse(version) {
        let parsedVersion;
        try {
            parsedVersion = new semver_1.SemVer(version);
        }
        catch {
            return null;
        }
        const result = {
            release: [parsedVersion.major, parsedVersion.minor, parsedVersion.patch],
            prerelease: parsedVersion.prerelease.length > 0
                ? parsedVersion.prerelease.join('.')
                : undefined,
        };
        const build = parsedVersion.build.at(0);
        if (build) {
            try {
                result.release.push(parseInt(build));
            }
            catch {
                /* noop */
            }
        }
        return result;
    }
}
exports.GlasskubeVersioningApi = GlasskubeVersioningApi;
exports.api = new GlasskubeVersioningApi();
exports.default = exports.api;
//# sourceMappingURL=index.js.map