"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isVersioningApiConstructor = isVersioningApiConstructor;
exports.getExcludedVersions = getExcludedVersions;
exports.getFilteredRange = getFilteredRange;
const regex_1 = require("../../util/regex");
function isVersioningApiConstructor(obj) {
    return typeof obj === 'function';
}
function getExcludedVersions(range) {
    return range
        .split(',')
        .map((v) => v.trim())
        .filter((version) => (0, regex_1.regEx)(/^!=/).test(version))
        .map((version) => version.replace('!=', '').trim());
}
function getFilteredRange(range) {
    return range
        .split(',')
        .map((v) => v.trim())
        .filter((version) => !(0, regex_1.regEx)(/^!=/).test(version))
        .join(',');
}
//# sourceMappingURL=common.js.map