"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.api = exports.supportsRanges = exports.urls = exports.displayName = exports.id = void 0;
const regex_1 = require("../../../util/regex");
const generic_1 = require("../generic");
exports.id = 'azure-rest-api';
exports.displayName = 'azure-rest-api';
exports.urls = [
    'https://github.com/microsoft/api-guidelines/blob/vNext/azure/Guidelines.md#api-versioning',
];
exports.supportsRanges = false;
const AZURE_REST_API_VERSION_REGEX = (0, regex_1.regEx)(/^(?<year>\d{4})-(?<month>\d{2})-(?<day>\d{2})(?<prerelease>-[a-z]+)?$/);
class AzureRestApiVersioningApi extends generic_1.GenericVersioningApi {
    _parse(version) {
        if (!version) {
            return null;
        }
        const matchGroups = AZURE_REST_API_VERSION_REGEX.exec(version)?.groups;
        if (!matchGroups) {
            return null;
        }
        const { year, month, day, prerelease } = matchGroups;
        return {
            release: [parseInt(`${year}${month}${day}`), 0, 0],
            prerelease,
        };
    }
    _compare(_version, _other) {
        if (_version === _other) {
            return 0;
        }
        return _version > _other ? 1 : -1;
    }
}
exports.api = new AzureRestApiVersioningApi();
exports.default = exports.api;
//# sourceMappingURL=index.js.map