"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.repoFingerprint = repoFingerprint;
exports.getNewBranchName = getNewBranchName;
const hash_1 = require("../../util/hash");
function repoFingerprint(repoId, endpoint) {
    const input = endpoint ? `${endpoint}::${repoId}` : `${repoId}`;
    const fingerprint = (0, hash_1.hash)(input);
    return fingerprint;
}
function getNewBranchName(branchName) {
    if (branchName && !branchName.startsWith('refs/heads/')) {
        return `refs/heads/${branchName}`;
    }
    return branchName;
}
//# sourceMappingURL=util.js.map