"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.scm = exports.platformScmImpls = void 0;
exports.setPlatformScmApi = setPlatformScmApi;
const error_messages_1 = require("../../constants/error-messages");
const default_scm_1 = require("./default-scm");
const scm_1 = require("./gerrit/scm");
const scm_2 = require("./github/scm");
const scm_3 = require("./local/scm");
exports.platformScmImpls = new Map();
exports.platformScmImpls.set('azure', default_scm_1.DefaultGitScm);
exports.platformScmImpls.set('codecommit', default_scm_1.DefaultGitScm);
exports.platformScmImpls.set('bitbucket', default_scm_1.DefaultGitScm);
exports.platformScmImpls.set('bitbucket-server', default_scm_1.DefaultGitScm);
exports.platformScmImpls.set('gerrit', scm_1.GerritScm);
exports.platformScmImpls.set('gitea', default_scm_1.DefaultGitScm);
exports.platformScmImpls.set('github', scm_2.GithubScm);
exports.platformScmImpls.set('gitlab', default_scm_1.DefaultGitScm);
exports.platformScmImpls.set('local', scm_3.LocalFs);
let _scm;
const handler = {
    get(_target, prop) {
        if (!_scm) {
            throw new Error(error_messages_1.PLATFORM_NOT_FOUND);
        }
        return _scm[prop];
    },
};
exports.scm = new Proxy({}, handler);
function setPlatformScmApi(name) {
    if (!exports.platformScmImpls.has(name)) {
        throw new Error(error_messages_1.PLATFORM_NOT_FOUND);
    }
    _scm = new (exports.platformScmImpls.get(name))();
}
//# sourceMappingURL=scm.js.map