"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LocalFs = void 0;
const node_child_process_1 = require("node:child_process");
const glob_1 = require("glob");
const logger_1 = require("../../../logger");
let fileList;
class LocalFs {
    isBranchBehindBase(branchName, baseBranch) {
        return Promise.resolve(false);
    }
    isBranchModified(branchName, baseBranch) {
        return Promise.resolve(false);
    }
    isBranchConflicted(baseBranch, branch) {
        return Promise.resolve(false);
    }
    branchExists(branchName) {
        return Promise.resolve(true);
    }
    getBranchCommit(branchName) {
        return Promise.resolve(null);
    }
    deleteBranch(branchName) {
        return Promise.resolve();
    }
    commitAndPush(commitConfig) {
        return Promise.resolve(null);
    }
    async getFileList() {
        try {
            // fetch file list using git
            const stdout = (0, node_child_process_1.execSync)('git ls-files', { encoding: 'utf-8' });
            logger_1.logger.debug('Got file list using git');
            fileList = stdout.split('\n');
        }
        catch {
            logger_1.logger.debug('Could not get file list using git, using glob instead');
            fileList ??= await (0, glob_1.glob)('**', {
                dot: true,
                nodir: true,
            });
        }
        return fileList;
    }
    checkoutBranch(branchName) {
        // We don't care about the commit sha in local mode
        return Promise.resolve('');
    }
    mergeAndPush(branchName) {
        return Promise.resolve();
    }
    mergeToLocal(branchName) {
        return Promise.resolve();
    }
}
exports.LocalFs = LocalFs;
//# sourceMappingURL=scm.js.map