import type { CommitFilesConfig, LongCommitSha } from '../../../util/git/types';
import type { PlatformScm } from '../types';
export declare class LocalFs implements PlatformScm {
    isBranchBehindBase(branchName: string, baseBranch: string): Promise<boolean>;
    isBranchModified(branchName: string, baseBranch: string): Promise<boolean>;
    isBranchConflicted(baseBranch: string, branch: string): Promise<boolean>;
    branchExists(branchName: string): Promise<boolean>;
    getBranchCommit(branchName: string): Promise<LongCommitSha | null>;
    deleteBranch(branchName: string): Promise<void>;
    commitAndPush(commitConfig: CommitFilesConfig): Promise<LongCommitSha | null>;
    getFileList(): Promise<string[]>;
    checkoutBranch(branchName: string): Promise<LongCommitSha>;
    mergeAndPush(branchName: string): Promise<void>;
    mergeToLocal(branchName: string): Promise<void>;
}
