"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DRAFT_PREFIX_DEPRECATED = exports.DRAFT_PREFIX = void 0;
exports.prInfo = prInfo;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const pr_body_1 = require("../pr-body");
exports.DRAFT_PREFIX = 'Draft: ';
exports.DRAFT_PREFIX_DEPRECATED = 'WIP: ';
function prInfo(mr) {
    const pr = {
        sourceBranch: mr.source_branch,
        state: mr.state === 'opened' ? 'open' : mr.state,
        number: mr.iid,
        title: mr.title,
        createdAt: mr.created_at,
        hasAssignees: !!(mr.assignee?.id ?? mr.assignees?.[0]?.id),
        bodyStruct: (0, pr_body_1.getPrBodyStruct)(mr.description),
        ...(mr.target_branch && { targetBranch: mr.target_branch }),
        ...(mr.head_pipeline?.status && {
            headPipelineStatus: mr.head_pipeline?.status,
        }),
        ...(mr.head_pipeline?.sha && { headPipelineSha: mr.head_pipeline?.sha }),
        ...(is_1.default.nonEmptyArray(mr.reviewers) && {
            reviewers: mr.reviewers?.map(({ username }) => username),
        }),
        ...(mr.labels && { labels: mr.labels }),
        ...(mr.sha && { sha: mr.sha }),
    };
    if (pr.title.startsWith(exports.DRAFT_PREFIX)) {
        pr.title = pr.title.substring(exports.DRAFT_PREFIX.length);
        pr.isDraft = true;
    }
    else if (pr.title.startsWith(exports.DRAFT_PREFIX_DEPRECATED)) {
        pr.title = pr.title.substring(exports.DRAFT_PREFIX_DEPRECATED.length);
        pr.isDraft = true;
    }
    return pr;
}
//# sourceMappingURL=utils.js.map