"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getMR = getMR;
exports.updateMR = updateMR;
const logger_1 = require("../../../logger");
const http_1 = require("./http");
async function getMR(repository, iid) {
    logger_1.logger.debug(`getMR(${iid})`);
    const url = `projects/${repository}/merge_requests/${iid}?include_diverged_commits_count=1`;
    return (await http_1.gitlabApi.getJsonUnchecked(url)).body;
}
async function updateMR(repository, iid, data) {
    logger_1.logger.debug(`updateMR(${iid})`);
    const url = `projects/${repository}/merge_requests/${iid}`;
    await http_1.gitlabApi.putJson(url, {
        body: data,
    });
}
//# sourceMappingURL=merge-request.js.map