import { z } from 'zod';
export declare const VulnerabilityAlertSchema: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
    dependency: {
        manifest_path: string;
    };
    security_advisory: {
        description: string;
        identifiers: {
            type: string;
            value: string;
        }[];
        references?: {
            url: string;
        }[] | undefined;
    };
    security_vulnerability: {
        package: {
            name: string;
            ecosystem: "rust" | "composer" | "maven" | "npm" | "nuget" | "pip" | "rubygems" | "go";
        };
        vulnerable_version_range: string;
        first_patched_version?: {
            identifier: string;
        } | null | undefined;
    } | null;
    dismissed_reason?: string | null | undefined;
}[], any[]>;
export declare const GithubFileMeta: z.ZodObject<{
    name: z.ZodString;
    path: z.ZodString;
} & {
    type: z.ZodLiteral<"file">;
}, "strip", z.ZodTypeAny, {
    path: string;
    type: "file";
    name: string;
}, {
    path: string;
    type: "file";
    name: string;
}>;
export type GithubFileMeta = z.infer<typeof GithubFileMeta>;
export declare const GithubFile: z.ZodObject<{
    name: z.ZodString;
    path: z.ZodString;
} & {
    type: z.ZodLiteral<"file">;
} & {
    content: z.ZodString;
    encoding: z.ZodString;
}, "strip", z.ZodTypeAny, {
    path: string;
    type: "file";
    name: string;
    encoding: string;
    content: string;
}, {
    path: string;
    type: "file";
    name: string;
    encoding: string;
    content: string;
}>;
export type GithubFile = z.infer<typeof GithubFile>;
export declare const GithubDirectory: z.ZodObject<{
    name: z.ZodString;
    path: z.ZodString;
} & {
    type: z.ZodLiteral<"dir">;
}, "strip", z.ZodTypeAny, {
    path: string;
    type: "dir";
    name: string;
}, {
    path: string;
    type: "dir";
    name: string;
}>;
export type GithubDirectory = z.infer<typeof GithubDirectory>;
export declare const GithubOtherContent: z.ZodObject<{
    name: z.ZodString;
    path: z.ZodString;
} & {
    type: z.ZodUnion<[z.ZodLiteral<"symlink">, z.ZodLiteral<"submodule">]>;
}, "strip", z.ZodTypeAny, {
    path: string;
    type: "submodule" | "symlink";
    name: string;
}, {
    path: string;
    type: "submodule" | "symlink";
    name: string;
}>;
export type GithubOtherContent = z.infer<typeof GithubOtherContent>;
export declare const GithubElement: z.ZodUnion<[z.ZodUnion<[z.ZodUnion<[z.ZodObject<{
    name: z.ZodString;
    path: z.ZodString;
} & {
    type: z.ZodLiteral<"file">;
} & {
    content: z.ZodString;
    encoding: z.ZodString;
}, "strip", z.ZodTypeAny, {
    path: string;
    type: "file";
    name: string;
    encoding: string;
    content: string;
}, {
    path: string;
    type: "file";
    name: string;
    encoding: string;
    content: string;
}>, z.ZodObject<{
    name: z.ZodString;
    path: z.ZodString;
} & {
    type: z.ZodLiteral<"file">;
}, "strip", z.ZodTypeAny, {
    path: string;
    type: "file";
    name: string;
}, {
    path: string;
    type: "file";
    name: string;
}>]>, z.ZodObject<{
    name: z.ZodString;
    path: z.ZodString;
} & {
    type: z.ZodLiteral<"dir">;
}, "strip", z.ZodTypeAny, {
    path: string;
    type: "dir";
    name: string;
}, {
    path: string;
    type: "dir";
    name: string;
}>]>, z.ZodObject<{
    name: z.ZodString;
    path: z.ZodString;
} & {
    type: z.ZodUnion<[z.ZodLiteral<"symlink">, z.ZodLiteral<"submodule">]>;
}, "strip", z.ZodTypeAny, {
    path: string;
    type: "submodule" | "symlink";
    name: string;
}, {
    path: string;
    type: "submodule" | "symlink";
    name: string;
}>]>;
export type GithubElement = z.infer<typeof GithubElement>;
export declare const GithubContentResponse: z.ZodUnion<[z.ZodArray<z.ZodUnion<[z.ZodUnion<[z.ZodUnion<[z.ZodObject<{
    name: z.ZodString;
    path: z.ZodString;
} & {
    type: z.ZodLiteral<"file">;
} & {
    content: z.ZodString;
    encoding: z.ZodString;
}, "strip", z.ZodTypeAny, {
    path: string;
    type: "file";
    name: string;
    encoding: string;
    content: string;
}, {
    path: string;
    type: "file";
    name: string;
    encoding: string;
    content: string;
}>, z.ZodObject<{
    name: z.ZodString;
    path: z.ZodString;
} & {
    type: z.ZodLiteral<"file">;
}, "strip", z.ZodTypeAny, {
    path: string;
    type: "file";
    name: string;
}, {
    path: string;
    type: "file";
    name: string;
}>]>, z.ZodObject<{
    name: z.ZodString;
    path: z.ZodString;
} & {
    type: z.ZodLiteral<"dir">;
}, "strip", z.ZodTypeAny, {
    path: string;
    type: "dir";
    name: string;
}, {
    path: string;
    type: "dir";
    name: string;
}>]>, z.ZodObject<{
    name: z.ZodString;
    path: z.ZodString;
} & {
    type: z.ZodUnion<[z.ZodLiteral<"symlink">, z.ZodLiteral<"submodule">]>;
}, "strip", z.ZodTypeAny, {
    path: string;
    type: "submodule" | "symlink";
    name: string;
}, {
    path: string;
    type: "submodule" | "symlink";
    name: string;
}>]>, "many">, z.ZodUnion<[z.ZodUnion<[z.ZodUnion<[z.ZodObject<{
    name: z.ZodString;
    path: z.ZodString;
} & {
    type: z.ZodLiteral<"file">;
} & {
    content: z.ZodString;
    encoding: z.ZodString;
}, "strip", z.ZodTypeAny, {
    path: string;
    type: "file";
    name: string;
    encoding: string;
    content: string;
}, {
    path: string;
    type: "file";
    name: string;
    encoding: string;
    content: string;
}>, z.ZodObject<{
    name: z.ZodString;
    path: z.ZodString;
} & {
    type: z.ZodLiteral<"file">;
}, "strip", z.ZodTypeAny, {
    path: string;
    type: "file";
    name: string;
}, {
    path: string;
    type: "file";
    name: string;
}>]>, z.ZodObject<{
    name: z.ZodString;
    path: z.ZodString;
} & {
    type: z.ZodLiteral<"dir">;
}, "strip", z.ZodTypeAny, {
    path: string;
    type: "dir";
    name: string;
}, {
    path: string;
    type: "dir";
    name: string;
}>]>, z.ZodObject<{
    name: z.ZodString;
    path: z.ZodString;
} & {
    type: z.ZodUnion<[z.ZodLiteral<"symlink">, z.ZodLiteral<"submodule">]>;
}, "strip", z.ZodTypeAny, {
    path: string;
    type: "submodule" | "symlink";
    name: string;
}, {
    path: string;
    type: "submodule" | "symlink";
    name: string;
}>]>]>;
