import type { BranchStatus, VulnerabilityAlert } from '../../../types';
import type { CommitFilesConfig, LongCommitSha } from '../../../util/git/types';
import type { AutodiscoverConfig, BranchStatusConfig, CreatePRConfig, EnsureCommentConfig, EnsureCommentRemovalConfig, EnsureIssueConfig, EnsureIssueResult, FindPRConfig, MergePRConfig, PlatformParams, PlatformResult, Pr, ReattemptPlatformAutomergeConfig, RepoParams, RepoResult, UpdatePrConfig } from '../types';
import { GithubIssue as Issue } from './issue';
import type { GhPr, GhRestRepo } from './types';
export declare const id = "github";
export declare function resetConfigs(): void;
export declare function isGHApp(): boolean;
export declare function detectGhe(token: string): Promise<void>;
export declare function initPlatform({ endpoint, token: originalToken, username, gitAuthor, }: PlatformParams): Promise<PlatformResult>;
export declare function getRepos(config?: AutodiscoverConfig): Promise<string[]>;
export declare function getRawFile(fileName: string, repoName?: string, branchOrTag?: string): Promise<string | null>;
export declare function getJsonFile(fileName: string, repoName?: string, branchOrTag?: string): Promise<any>;
export declare function listForks(token: string, repository: string): Promise<GhRestRepo[]>;
export declare function findFork(token: string, repository: string, forkOrg?: string): Promise<GhRestRepo | null>;
export declare function createFork(token: string, repository: string, forkOrg?: string): Promise<GhRestRepo>;
export declare function initRepo({ endpoint, repository, forkCreation, forkOrg, forkToken, renovateUsername, cloneSubmodules, cloneSubmodulesFilter, ignorePrAuthor, }: RepoParams): Promise<RepoResult>;
export declare function getBranchForceRebase(branchName: string): Promise<boolean>;
export declare function getPr(prNo: number): Promise<GhPr | null>;
export declare function getPrList(): Promise<GhPr[]>;
export declare function findPr({ branchName, prTitle, state, includeOtherAuthors, }: FindPRConfig): Promise<GhPr | null>;
export declare function getBranchPr(branchName: string): Promise<GhPr | null>;
export declare function tryReuseAutoclosedPr(autoclosedPr: Pr): Promise<Pr | null>;
export declare function getBranchStatus(branchName: string, internalChecksAsSuccess: boolean): Promise<BranchStatus>;
export declare function getBranchStatusCheck(branchName: string, context: string): Promise<BranchStatus | null>;
export declare function setBranchStatus({ branchName, context, description, state, url: targetUrl, }: BranchStatusConfig): Promise<void>;
export declare function getIssueList(): Promise<Issue[]>;
export declare function getIssue(number: number): Promise<Issue | null>;
export declare function findIssue(title: string): Promise<Issue | null>;
export declare function ensureIssue({ title, reuseTitle, body: rawBody, labels, once, shouldReOpen, }: EnsureIssueConfig): Promise<EnsureIssueResult | null>;
export declare function ensureIssueClosing(title: string): Promise<void>;
export declare function addAssignees(issueNo: number, assignees: string[]): Promise<void>;
export declare function addReviewers(prNo: number, reviewers: string[]): Promise<void>;
export declare function addLabels(issueNo: number, labels: string[] | null | undefined): Promise<void>;
export declare function deleteLabel(issueNo: number, label: string): Promise<void>;
export declare function ensureComment({ number, topic, content, }: EnsureCommentConfig): Promise<boolean>;
export declare function ensureCommentRemoval(deleteConfig: EnsureCommentRemovalConfig): Promise<void>;
export declare function createPr({ sourceBranch, targetBranch, prTitle: title, prBody: rawBody, labels, draftPR, platformPrOptions, milestone, }: CreatePRConfig): Promise<GhPr | null>;
export declare function updatePr({ number: prNo, prTitle: title, prBody: rawBody, addLabels: labelsToAdd, removeLabels, state, targetBranch, }: UpdatePrConfig): Promise<void>;
export declare function reattemptPlatformAutomerge({ number, platformPrOptions, }: ReattemptPlatformAutomergeConfig): Promise<void>;
export declare function mergePr({ branchName, id: prNo, strategy, }: MergePRConfig): Promise<boolean>;
export declare function massageMarkdown(input: string): string;
export declare function maxBodyLength(): number;
export declare function getVulnerabilityAlerts(): Promise<VulnerabilityAlert[]>;
export declare function commitFiles(config: CommitFilesConfig): Promise<LongCommitSha | null>;
