import type { MergeStrategy } from '../../../config/types';
import type { GitUrlOption, Pr } from '../types';
import type { PR, PRMergeMethod, Repo } from './types';
export declare function smartLinks(body: string): string;
export declare function trimTrailingApiPath(url: string): string;
export declare function getRepoUrl(repo: Repo, gitUrl: GitUrlOption | undefined, endpoint: string): string;
export declare function getMergeMethod(strategy: MergeStrategy | undefined): PRMergeMethod | null;
export declare const API_PATH = "/api/v1";
export declare const DRAFT_PREFIX = "WIP: ";
export declare function toRenovatePR(data: PR, author: string | null): Pr | null;
/**
 * Check if a repository is usable.
 * A repo isn't usable if one of the following conditions is met:
 * - The repo is a `mirror`
 * - We don't have pull or push permissions
 * - Pull requests are disabled
 * @param repo Repo to check
 * @returns  `true` if the repository is usable, `false` otherwise
 */
export declare function usableRepo(repo: Repo): boolean;
