import type { BranchStatus } from '../../../types';
import type { AutodiscoverConfig, BranchStatusConfig, CreatePRConfig, EnsureCommentConfig, EnsureIssueConfig, FindPRConfig, Issue, MergePRConfig, PlatformParams, PlatformResult, Pr, RepoParams, RepoResult, UpdatePrConfig } from '../types';
export declare const id = "gitea";
export declare function resetPlatform(): void;
export declare function maxBodyLength(): number;
export declare const addAssignees: (number: number, assignees: string[]) => Promise<void>, addReviewers: (number: number, reviewers: string[]) => Promise<void>, createPr: (prConfig: CreatePRConfig) => Promise<Pr | null>, deleteLabel: (number: number, label: string) => Promise<void>, ensureComment: (ensureComment: EnsureCommentConfig) => Promise<boolean>, ensureCommentRemoval: (ensureCommentRemoval: import("../types").EnsureCommentRemovalConfigByTopic | import("../types").EnsureCommentRemovalConfigByContent) => Promise<void>, ensureIssue: (issueConfig: EnsureIssueConfig) => Promise<import("../types").EnsureIssueResult | null>, ensureIssueClosing: (title: string) => Promise<void>, findIssue: (title: string) => Promise<Issue | null>, findPr: (findPRConfig: FindPRConfig) => Promise<Pr | null>, getBranchPr: (branchName: string, targetBranch?: string) => Promise<Pr | null>, getBranchStatus: (branchName: string, internalChecksAsSuccess: boolean) => Promise<BranchStatus>, getBranchStatusCheck: (branchName: string, context: string | null | undefined) => Promise<BranchStatus | null>, getIssue: ((number: number, memCache?: boolean) => Promise<Issue | null>) | undefined, getRawFile: (fileName: string, repoName?: string, branchOrTag?: string) => Promise<string | null>, getJsonFile: (fileName: string, repoName?: string, branchOrTag?: string) => Promise<any>, getIssueList: () => Promise<Issue[]>, getPr: (number: number) => Promise<Pr | null>, massageMarkdown: (prBody: string, rebaseLabel?: string) => string, getPrList: () => Promise<Pr[]>, getRepos: (config?: AutodiscoverConfig) => Promise<string[]>, initPlatform: (config: PlatformParams) => Promise<PlatformResult>, initRepo: (config: RepoParams) => Promise<RepoResult>, mergePr: (config: MergePRConfig) => Promise<boolean>, setBranchStatus: (branchStatusConfig: BranchStatusConfig) => Promise<void>, updatePr: (prConfig: UpdatePrConfig) => Promise<void>;
