import type { BranchStatus } from '../../../types';
import type { GiteaHttpOptions } from '../../../util/http/gitea';
import { GiteaHttp } from '../../../util/http/gitea';
import type { Branch, CombinedCommitStatus, Comment, CommitStatus, CommitStatusCreateParams, CommitStatusType, Issue, IssueCreateParams, IssueSearchParams, IssueUpdateLabelsParams, IssueUpdateParams, Label, PR, PRCreateParams, PRMergeParams, PRUpdateParams, PrReviewersParams, Repo, RepoContents, RepoSearchParams, User } from './types';
export declare const giteaHttp: GiteaHttp;
export declare function getCurrentUser(options?: GiteaHttpOptions): Promise<User>;
export declare function getVersion(options?: GiteaHttpOptions): Promise<string>;
export declare function searchRepos(params: RepoSearchParams, options?: GiteaHttpOptions): Promise<Repo[]>;
export declare function orgListRepos(organization: string, options?: GiteaHttpOptions): Promise<Repo[]>;
export declare function getRepo(repoPath: string, options?: GiteaHttpOptions): Promise<Repo>;
export declare function getRepoContents(repoPath: string, filePath: string, ref?: string | null, options?: GiteaHttpOptions): Promise<RepoContents>;
export declare function createPR(repoPath: string, params: PRCreateParams, options?: GiteaHttpOptions): Promise<PR>;
export declare function updatePR(repoPath: string, idx: number, params: PRUpdateParams, options?: GiteaHttpOptions): Promise<PR>;
export declare function closePR(repoPath: string, idx: number, options?: GiteaHttpOptions): Promise<void>;
export declare function mergePR(repoPath: string, idx: number, params: PRMergeParams, options?: GiteaHttpOptions): Promise<void>;
export declare function getPR(repoPath: string, idx: number, options?: GiteaHttpOptions): Promise<PR>;
export declare function getPRByBranch(repoPath: string, base: string, head: string, options?: GiteaHttpOptions): Promise<PR | null>;
export declare function requestPrReviewers(repoPath: string, idx: number, params: PrReviewersParams, options?: GiteaHttpOptions): Promise<void>;
export declare function createIssue(repoPath: string, params: IssueCreateParams, options?: GiteaHttpOptions): Promise<Issue>;
export declare function updateIssue(repoPath: string, idx: number, params: IssueUpdateParams, options?: GiteaHttpOptions): Promise<Issue>;
export declare function updateIssueLabels(repoPath: string, idx: number, params: IssueUpdateLabelsParams, options?: GiteaHttpOptions): Promise<Label[]>;
export declare function closeIssue(repoPath: string, idx: number, options?: GiteaHttpOptions): Promise<void>;
export declare function searchIssues(repoPath: string, params: IssueSearchParams, options?: GiteaHttpOptions): Promise<Issue[]>;
export declare function getIssue(repoPath: string, idx: number, options?: GiteaHttpOptions): Promise<Issue>;
export declare function getRepoLabels(repoPath: string, options?: GiteaHttpOptions): Promise<Label[]>;
export declare function getOrgLabels(orgName: string, options?: GiteaHttpOptions): Promise<Label[]>;
export declare function unassignLabel(repoPath: string, issue: number, label: number, options?: GiteaHttpOptions): Promise<void>;
export declare function createComment(repoPath: string, issue: number, body: string, options?: GiteaHttpOptions): Promise<Comment>;
export declare function updateComment(repoPath: string, idx: number, body: string, options?: GiteaHttpOptions): Promise<Comment>;
export declare function deleteComment(repoPath: string, idx: number, options?: GiteaHttpOptions): Promise<void>;
export declare function getComments(repoPath: string, issue: number, options?: GiteaHttpOptions): Promise<Comment[]>;
export declare function createCommitStatus(repoPath: string, branchCommit: string, params: CommitStatusCreateParams, options?: GiteaHttpOptions): Promise<CommitStatus>;
export declare const giteaToRenovateStatusMapping: Record<CommitStatusType, BranchStatus | null>;
export declare const renovateToGiteaStatusMapping: Record<BranchStatus, CommitStatusType>;
export declare function getCombinedCommitStatus(repoPath: string, branchName: string, options?: GiteaHttpOptions): Promise<CombinedCommitStatus>;
export declare function getBranch(repoPath: string, branchName: string, options?: GiteaHttpOptions): Promise<Branch>;
