import type { CommitFilesConfig, LongCommitSha } from '../../../util/git/types';
import { DefaultGitScm } from '../default-scm';
export declare function configureScm(repo: string, login: string): void;
export declare class GerritScm extends DefaultGitScm {
    branchExists(branchName: string): Promise<boolean>;
    getBranchCommit(branchName: string): Promise<LongCommitSha | null>;
    isBranchBehindBase(branchName: string, baseBranch: string): Promise<boolean>;
    isBranchConflicted(baseBranch: string, branch: string): Promise<boolean>;
    isBranchModified(branchName: string, baseBranch: string): Promise<boolean>;
    commitAndPush(commit: CommitFilesConfig): Promise<LongCommitSha | null>;
    deleteBranch(branchName: string): Promise<void>;
    mergeToLocal(branchName: string): Promise<void>;
}
