import type { BranchStatus } from '../../../types';
import type { BranchStatusConfig, CreatePRConfig, EnsureCommentConfig, EnsureCommentRemovalConfigByContent, EnsureCommentRemovalConfigByTopic, EnsureIssueConfig, EnsureIssueResult, FindPRConfig, Issue, MergePRConfig, PlatformParams, PlatformResult, Pr, RepoParams, RepoResult, UpdatePrConfig } from '../types';
import type { GerritLabelTypeInfo, GerritProjectInfo } from './types';
export declare const id = "gerrit";
declare let config: {
    repository?: string;
    head?: string;
    config?: GerritProjectInfo;
    labels: Record<string, GerritLabelTypeInfo>;
    gerritUsername?: string;
};
export declare function writeToConfig(newConfig: typeof config): void;
export declare function initPlatform({ endpoint, username, password, }: PlatformParams): Promise<PlatformResult>;
/**
 * Get all state="ACTIVE" and type="CODE" repositories from gerrit
 */
export declare function getRepos(): Promise<string[]>;
/**
 * Clone repository to local directory
 * @param config
 */
export declare function initRepo({ repository, gitUrl, }: RepoParams): Promise<RepoResult>;
export declare function findPr(findPRConfig: FindPRConfig): Promise<Pr | null>;
export declare function getPr(number: number, refreshCache?: boolean): Promise<Pr | null>;
export declare function updatePr(prConfig: UpdatePrConfig): Promise<void>;
export declare function createPr(prConfig: CreatePRConfig): Promise<Pr | null>;
export declare function getBranchPr(branchName: string, targetBranch?: string): Promise<Pr | null>;
export declare function refreshPr(number: number): Promise<void>;
export declare function getPrList(): Promise<Pr[]>;
export declare function mergePr(config: MergePRConfig): Promise<boolean>;
/**
 * BranchStatus for Gerrit assumes that the branchName refers to a change.
 * @param branchName
 */
export declare function getBranchStatus(branchName: string): Promise<BranchStatus>;
/**
 * check the gerrit-change for the presence of the corresponding "$context" Gerrit label if configured,
 *  return 'yellow' if not configured or not set
 * @param branchName
 * @param context renovate/stability-days || ...
 */
export declare function getBranchStatusCheck(branchName: string, context: string): Promise<BranchStatus | null>;
/**
 * Apply the branch state $context to the corresponding gerrit label (if available)
 * context === "renovate/stability-days" / "renovate/merge-confidence" and state === "green"/...
 * @param branchStatusConfig
 */
export declare function setBranchStatus(branchStatusConfig: BranchStatusConfig): Promise<void>;
export declare function getRawFile(fileName: string, repoName?: string, branchOrTag?: string): Promise<string | null>;
export declare function getJsonFile(fileName: string, repoName?: string, branchOrTag?: string): Promise<any>;
export declare function addReviewers(number: number, reviewers: string[]): Promise<void>;
/**
 * add "CC" (only one possible)
 */
export declare function addAssignees(number: number, assignees: string[]): Promise<void>;
export declare function ensureComment(ensureComment: EnsureCommentConfig): Promise<boolean>;
export declare function massageMarkdown(prBody: string, rebaseLabel: string): string;
export declare function maxBodyLength(): number;
export declare function deleteLabel(number: number, label: string): Promise<void>;
export declare function ensureCommentRemoval(ensureCommentRemoval: EnsureCommentRemovalConfigByTopic | EnsureCommentRemovalConfigByContent): Promise<void>;
export declare function ensureIssueClosing(title: string): Promise<void>;
export declare function ensureIssue(issueConfig: EnsureIssueConfig): Promise<EnsureIssueResult | null>;
export declare function findIssue(title: string): Promise<Issue | null>;
export declare function getIssueList(): Promise<Issue[]>;
export {};
