import type { GerritBranchInfo, GerritChange, GerritChangeMessageInfo, GerritFindPRConfig, GerritMergeableInfo, GerritProjectInfo, GerritRequestDetail } from './types';
declare class GerritClient {
    private gerritHttp;
    getRepos(): Promise<string[]>;
    getProjectInfo(repository: string): Promise<GerritProjectInfo>;
    getBranchInfo(repository: string): Promise<GerritBranchInfo>;
    findChanges(repository: string, findPRConfig: GerritFindPRConfig): Promise<GerritChange[]>;
    getChange(changeNumber: number, refreshCache?: boolean, requestDetails?: GerritRequestDetail[]): Promise<GerritChange>;
    getMergeableInfo(change: GerritChange): Promise<GerritMergeableInfo>;
    abandonChange(changeNumber: number, message?: string): Promise<void>;
    submitChange(changeNumber: number): Promise<GerritChange>;
    getMessages(changeNumber: number): Promise<GerritChangeMessageInfo[]>;
    addMessage(changeNumber: number, fullMessage: string, tag?: string): Promise<void>;
    checkForExistingMessage(changeNumber: number, newMessage: string, msgType?: string, messages?: GerritChangeMessageInfo[]): Promise<boolean>;
    addMessageIfNotAlreadyExists(changeNumber: number, message: string, tag?: string, messages?: GerritChangeMessageInfo[]): Promise<void>;
    setLabel(changeNumber: number, label: string, value: number): Promise<void>;
    deleteHashtag(changeNumber: number, hashtag: string): Promise<void>;
    addReviewers(changeNumber: number, reviewers: string[]): Promise<void>;
    addAssignee(changeNumber: number, assignee: string): Promise<void>;
    getFile(repo: string, branch: string, fileName: string): Promise<string>;
    normalizeMessage(message: string): string;
    private static buildSearchFilters;
}
export declare const client: GerritClient;
export {};
