import type { CommitFilesConfig, LongCommitSha } from '../../util/git/types';
import type { PlatformScm } from './types';
export declare class DefaultGitScm implements PlatformScm {
    branchExists(branchName: string): Promise<boolean>;
    commitAndPush(commitConfig: CommitFilesConfig): Promise<LongCommitSha | null>;
    deleteBranch(branchName: string): Promise<void>;
    getBranchCommit(branchName: string): Promise<LongCommitSha | null>;
    isBranchBehindBase(branchName: string, baseBranch: string): Promise<boolean>;
    isBranchConflicted(baseBranch: string, branch: string): Promise<boolean>;
    isBranchModified(branchName: string, baseBranch: string): Promise<boolean>;
    getFileList(): Promise<string[]>;
    checkoutBranch(branchName: string): Promise<LongCommitSha>;
    mergeAndPush(branchName: string): Promise<void>;
    mergeToLocal(branchName: string): Promise<void>;
    syncForkWithUpstream(branchName: string): Promise<void>;
}
