"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ensureComment = ensureComment;
exports.ensureCommentRemoval = ensureCommentRemoval;
const repository_1 = require("../../util/cache/repository");
const hash_1 = require("../../util/hash");
const _1 = require(".");
async function ensureComment(commentConfig) {
    const { number, content } = commentConfig;
    const topic = commentConfig.topic ?? '';
    const contentHash = (0, hash_1.hash)(content);
    const repoCache = (0, repository_1.getCache)();
    if (contentHash !== repoCache.prComments?.[number]?.[topic]) {
        const res = await _1.platform.ensureComment(commentConfig);
        if (res) {
            repoCache.prComments ??= {};
            repoCache.prComments[number] ??= {};
            repoCache.prComments[number][topic] = contentHash;
        }
        return res;
    }
    return true;
}
async function ensureCommentRemoval(config) {
    await _1.platform.ensureCommentRemoval(config);
    const repoCache = (0, repository_1.getCache)();
    const { type, number } = config;
    if (repoCache.prComments?.[number]) {
        if (type === 'by-topic') {
            delete repoCache.prComments?.[number]?.[config.topic];
        }
        else if (type === 'by-content') {
            const contentHash = (0, hash_1.hash)(config.content);
            for (const [cachedTopic, cachedContentHash] of Object.entries(repoCache.prComments?.[number])) {
                if (cachedContentHash === contentHash) {
                    delete repoCache.prComments?.[number]?.[cachedTopic];
                    return;
                }
            }
        }
    }
}
//# sourceMappingURL=comment.js.map