import type { BranchStatus } from '../../../types';
import type { BranchStatusConfig, CreatePRConfig, EnsureCommentConfig, EnsureCommentRemovalConfig, EnsureIssueConfig, EnsureIssueResult, FindPRConfig, Issue, MergePRConfig, PlatformParams, PlatformResult, Pr, RepoParams, RepoResult, UpdatePrConfig } from '../types';
export interface CodeCommitPr extends Pr {
    body: string;
    destinationCommit: string;
    sourceCommit: string;
}
interface Config {
    repository?: string;
    defaultBranch?: string;
    region?: string;
    prList?: CodeCommitPr[];
}
export declare const id = "codecommit";
export declare const config: Config;
export declare function initPlatform({ endpoint, username, password, token: awsToken, }: PlatformParams): Promise<PlatformResult>;
export declare function initRepo({ repository, endpoint, }: RepoParams): Promise<RepoResult>;
export declare function getPrList(): Promise<CodeCommitPr[]>;
export declare function findPr({ branchName, prTitle, state, }: FindPRConfig): Promise<CodeCommitPr | null>;
export declare function getBranchPr(branchName: string): Promise<CodeCommitPr | null>;
export declare function getPr(pullRequestId: number): Promise<CodeCommitPr | null>;
export declare function getRepos(): Promise<string[]>;
export declare function massageMarkdown(input: string): string;
/**
 * Unsed, no Dashboard
 */
export declare function maxBodyLength(): number;
export declare function getJsonFile(fileName: string, repoName?: string, branchOrTag?: string): Promise<any>;
export declare function getRawFile(fileName: string, repoName?: string, branchOrTag?: string): Promise<string | null>;
export declare function createPr({ sourceBranch, targetBranch, prTitle: title, prBody: body, }: CreatePRConfig): Promise<CodeCommitPr>;
export declare function updatePr({ number: prNo, prTitle: title, prBody: body, state, }: UpdatePrConfig): Promise<void>;
export declare function mergePr({ branchName, id: prNo, strategy, }: MergePRConfig): Promise<boolean>;
export declare function addReviewers(prNo: number, reviewers: string[]): Promise<void>;
export declare function addAssignees(iid: number, assignees: string[]): Promise<void>;
export declare function findIssue(title: string): Promise<Issue | null>;
export declare function ensureIssue({ title, }: EnsureIssueConfig): Promise<EnsureIssueResult | null>;
export declare function getIssueList(): Promise<Issue[]>;
export declare function ensureIssueClosing(title: string): Promise<void>;
export declare function deleteLabel(prNumber: number, label: string): Promise<void>;
export declare function getBranchStatus(branchName: string): Promise<BranchStatus>;
export declare function getBranchStatusCheck(branchName: string, context: string): Promise<BranchStatus | null>;
export declare function setBranchStatus({ branchName, context, description, state, url: targetUrl, }: BranchStatusConfig): Promise<void>;
export declare function ensureComment({ number, topic, content, }: EnsureCommentConfig): Promise<boolean>;
export declare function ensureCommentRemoval(removeConfig: EnsureCommentRemovalConfig): Promise<void>;
export {};
