import type { CreatePullRequestApprovalRuleOutput, CreatePullRequestOutput, DeleteCommentContentOutput, GetCommentsForPullRequestOutput, GetFileOutput, GetPullRequestOutput, GetRepositoryOutput, ListPullRequestsOutput, ListRepositoriesOutput, PostCommentForPullRequestOutput, UpdateCommentOutput, UpdatePullRequestDescriptionOutput, UpdatePullRequestStatusOutput, UpdatePullRequestTitleOutput } from '@aws-sdk/client-codecommit';
import { PullRequestStatusEnum } from '@aws-sdk/client-codecommit';
import type { RepositoryMetadata } from '@aws-sdk/client-codecommit/dist-types/models/models_0';
export declare function buildCodeCommitClient(): void;
export declare function deleteComment(commentId: string): Promise<DeleteCommentContentOutput>;
export declare function getPrComments(pullRequestId: string): Promise<GetCommentsForPullRequestOutput>;
export declare function updateComment(commentId: string, content: string): Promise<UpdateCommentOutput>;
export declare function createPrComment(pullRequestId: string, repositoryName: string | undefined, content: string, beforeCommitId: string, afterCommitId: string): Promise<PostCommentForPullRequestOutput>;
export declare function updatePrStatus(pullRequestId: string, pullRequestStatus: PullRequestStatusEnum): Promise<UpdatePullRequestStatusOutput>;
export declare function updatePrTitle(prNo: string, title: string): Promise<UpdatePullRequestTitleOutput>;
export declare function updatePrDescription(pullRequestId: string, description: string): Promise<UpdatePullRequestDescriptionOutput>;
export declare function createPr(title: string, description: string, sourceReference: string, destinationReference: string, repositoryName: string | undefined): Promise<CreatePullRequestOutput>;
export declare function getFile(repositoryName: string | undefined, filePath: string, commitSpecifier: string | undefined): Promise<GetFileOutput>;
export declare function listPullRequests(repositoryName: string): Promise<ListPullRequestsOutput>;
export declare function getRepositoryInfo(repository: string): Promise<GetRepositoryOutput>;
export declare function getPr(pullRequestId: string): Promise<GetPullRequestOutput | undefined>;
export declare function listRepositories(): Promise<ListRepositoriesOutput>;
export declare function createPrApprovalRule(pullRequestId: string, approvalRuleContent: string): Promise<CreatePullRequestApprovalRuleOutput>;
export declare function getCodeCommitUrl(repoMetadata: RepositoryMetadata, repoName: string): string;
