"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.prFieldsFilter = exports.buildStates = exports.prStates = void 0;
exports.mergeBodyTransformer = mergeBodyTransformer;
exports.prInfo = prInfo;
const pr_body_1 = require("../pr-body");
const bitbucketMergeStrategies = new Map([
    ['squash', 'squash'],
    ['merge-commit', 'merge_commit'],
    ['fast-forward', 'fast_forward'],
]);
function mergeBodyTransformer(mergeStrategy) {
    const body = {
        close_source_branch: true,
    };
    // The `auto` strategy will use the strategy configured inside Bitbucket.
    if (mergeStrategy && mergeStrategy !== 'auto') {
        body.merge_strategy = bitbucketMergeStrategies.get(mergeStrategy);
    }
    return body;
}
exports.prStates = {
    open: ['OPEN'],
    notOpen: ['MERGED', 'DECLINED', 'SUPERSEDED'],
    merged: ['MERGED'],
    closed: ['DECLINED', 'SUPERSEDED'],
    all: ['OPEN', 'MERGED', 'DECLINED', 'SUPERSEDED'],
};
exports.buildStates = {
    green: 'SUCCESSFUL',
    red: 'FAILED',
    yellow: 'INPROGRESS',
};
function prInfo(pr) {
    return {
        number: pr.id,
        bodyStruct: (0, pr_body_1.getPrBodyStruct)(pr.summary?.raw),
        sourceBranch: pr.source?.branch?.name,
        targetBranch: pr.destination?.branch?.name,
        title: pr.title,
        state: /* v8 ignore start */ exports.prStates.closed?.includes(pr.state)
            ? 'closed'
            : pr.state?.toLowerCase() /* v8 ignore stop */,
        createdAt: pr.created_on,
    };
}
exports.prFieldsFilter = [
    'values.id',
    'values.title',
    'values.state',
    'values.links.commits.href',
    'values.summary.raw',
    'values.source.branch.name',
    'values.destination.branch.name',
    'values.reviewers.display_name',
    'values.reviewers.uuid',
    'values.reviewers.nickname',
    'values.reviewers.account_status',
    'values.created_on',
    'values.updated_on',
].join(',');
//# sourceMappingURL=utils.js.map