import { z } from 'zod';
export declare const PagedSourceResultsSchema: z.ZodObject<{
    page: z.ZodOptional<z.ZodNumber>;
    pagelen: z.ZodNumber;
    size: z.ZodOptional<z.ZodNumber>;
    next: z.ZodOptional<z.ZodString>;
} & {
    values: z.ZodArray<z.ZodObject<{
        path: z.ZodString;
        type: z.ZodEnum<["commit_directory", "commit_file"]>;
        commit: z.ZodObject<{
            hash: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            hash: string;
        }, {
            hash: string;
        }>;
    }, "strip", z.ZodTypeAny, {
        path: string;
        commit: {
            hash: string;
        };
        type: "commit_directory" | "commit_file";
    }, {
        path: string;
        commit: {
            hash: string;
        };
        type: "commit_directory" | "commit_file";
    }>, "many">;
}, "strip", z.ZodTypeAny, {
    values: {
        path: string;
        commit: {
            hash: string;
        };
        type: "commit_directory" | "commit_file";
    }[];
    pagelen: number;
    size?: number | undefined;
    next?: string | undefined;
    page?: number | undefined;
}, {
    values: {
        path: string;
        commit: {
            hash: string;
        };
        type: "commit_directory" | "commit_file";
    }[];
    pagelen: number;
    size?: number | undefined;
    next?: string | undefined;
    page?: number | undefined;
}>;
export declare const RepoInfo: z.ZodEffects<z.ZodObject<{
    parent: z.ZodCatch<z.ZodOptional<z.ZodUnknown>>;
    mainbranch: z.ZodObject<{
        name: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        name: string;
    }, {
        name: string;
    }>;
    has_issues: z.ZodCatch<z.ZodBoolean>;
    uuid: z.ZodString;
    full_name: z.ZodString;
    is_private: z.ZodCatch<z.ZodBoolean>;
    project: z.ZodCatch<z.ZodNullable<z.ZodObject<{
        name: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        name: string;
    }, {
        name: string;
    }>>>;
}, "strip", z.ZodTypeAny, {
    uuid: string;
    mainbranch: {
        name: string;
    };
    has_issues: boolean;
    full_name: string;
    is_private: boolean;
    project: {
        name: string;
    } | null;
    parent?: unknown;
}, {
    uuid: string;
    mainbranch: {
        name: string;
    };
    full_name: string;
    parent?: unknown;
    has_issues?: unknown;
    is_private?: unknown;
    project?: unknown;
}>, {
    isFork: boolean;
    owner: string;
    name: string;
    mainbranch: string;
    mergeMethod: string;
    has_issues: boolean;
    uuid: string;
    is_private: boolean;
    projectName: string | undefined;
}, {
    uuid: string;
    mainbranch: {
        name: string;
    };
    full_name: string;
    parent?: unknown;
    has_issues?: unknown;
    is_private?: unknown;
    project?: unknown;
}>;
export type RepoInfo = z.infer<typeof RepoInfo>;
export declare const Repositories: z.ZodEffects<z.ZodObject<{
    values: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
        isFork: boolean;
        owner: string;
        name: string;
        mainbranch: string;
        mergeMethod: string;
        has_issues: boolean;
        uuid: string;
        is_private: boolean;
        projectName: string | undefined;
    }[], any[]>;
}, "strip", z.ZodTypeAny, {
    values: {
        isFork: boolean;
        owner: string;
        name: string;
        mainbranch: string;
        mergeMethod: string;
        has_issues: boolean;
        uuid: string;
        is_private: boolean;
        projectName: string | undefined;
    }[];
}, {
    values: any[];
}>, {
    isFork: boolean;
    owner: string;
    name: string;
    mainbranch: string;
    mergeMethod: string;
    has_issues: boolean;
    uuid: string;
    is_private: boolean;
    projectName: string | undefined;
}[], {
    values: any[];
}>;
declare const PrTask: z.ZodObject<{
    id: z.ZodNumber;
    state: z.ZodUnion<[z.ZodLiteral<"RESOLVED">, z.ZodLiteral<"UNRESOLVED">]>;
    content: z.ZodObject<{
        raw: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        raw: string;
    }, {
        raw: string;
    }>;
}, "strip", z.ZodTypeAny, {
    id: number;
    state: "RESOLVED" | "UNRESOLVED";
    content: {
        raw: string;
    };
}, {
    id: number;
    state: "RESOLVED" | "UNRESOLVED";
    content: {
        raw: string;
    };
}>;
export type PrTask = z.infer<typeof PrTask>;
export declare const UnresolvedPrTasks: z.ZodEffects<z.ZodObject<{
    values: z.ZodArray<z.ZodObject<{
        id: z.ZodNumber;
        state: z.ZodUnion<[z.ZodLiteral<"RESOLVED">, z.ZodLiteral<"UNRESOLVED">]>;
        content: z.ZodObject<{
            raw: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            raw: string;
        }, {
            raw: string;
        }>;
    }, "strip", z.ZodTypeAny, {
        id: number;
        state: "RESOLVED" | "UNRESOLVED";
        content: {
            raw: string;
        };
    }, {
        id: number;
        state: "RESOLVED" | "UNRESOLVED";
        content: {
            raw: string;
        };
    }>, "many">;
}, "strip", z.ZodTypeAny, {
    values: {
        id: number;
        state: "RESOLVED" | "UNRESOLVED";
        content: {
            raw: string;
        };
    }[];
}, {
    values: {
        id: number;
        state: "RESOLVED" | "UNRESOLVED";
        content: {
            raw: string;
        };
    }[];
}>, {
    id: number;
    state: "RESOLVED" | "UNRESOLVED";
    content: {
        raw: string;
    };
}[], {
    values: {
        id: number;
        state: "RESOLVED" | "UNRESOLVED";
        content: {
            raw: string;
        };
    }[];
}>;
export {};
