import type { BranchStatus } from '../../../types';
import type { AutodiscoverConfig, BranchStatusConfig, CreatePRConfig, EnsureCommentConfig, EnsureCommentRemovalConfig, EnsureIssueConfig, EnsureIssueResult, FindPRConfig, Issue, MergePRConfig, PlatformParams, PlatformResult, Pr, RepoParams, RepoResult, UpdatePrConfig } from '../types';
export declare const id = "bitbucket";
export declare function resetPlatform(): void;
export declare function initPlatform({ endpoint, username, password, token, }: PlatformParams): Promise<PlatformResult>;
export declare function getRepos(config: AutodiscoverConfig): Promise<string[]>;
export declare function getRawFile(fileName: string, repoName?: string, branchOrTag?: string): Promise<string | null>;
export declare function getJsonFile(fileName: string, repoName?: string, branchOrTag?: string): Promise<any>;
export declare function initRepo({ repository, cloneSubmodules, cloneSubmodulesFilter, ignorePrAuthor, bbUseDevelopmentBranch, }: RepoParams): Promise<RepoResult>;
export declare function getPrList(): Promise<Pr[]>;
export declare function findPr({ branchName, prTitle, state, includeOtherAuthors, }: FindPRConfig): Promise<Pr | null>;
export declare function getPr(prNo: number): Promise<Pr | null>;
export declare function getBranchPr(branchName: string): Promise<Pr | null>;
export declare function getBranchStatus(branchName: string, internalChecksAsSuccess: boolean): Promise<BranchStatus>;
export declare function getBranchStatusCheck(branchName: string, context: string): Promise<BranchStatus | null>;
export declare function setBranchStatus({ branchName, context, description, state, url: targetUrl, }: BranchStatusConfig): Promise<void>;
export declare function findIssue(title: string): Promise<Issue | null>;
export declare function massageMarkdown(input: string): string;
export declare function maxBodyLength(): number;
export declare function ensureIssue({ title, reuseTitle, body, }: EnsureIssueConfig): Promise<EnsureIssueResult | null>;
export declare function getIssueList(): Promise<Issue[]>;
export declare function ensureIssueClosing(title: string): Promise<void>;
export declare function addAssignees(_prNr: number, _assignees: string[]): Promise<void>;
export declare function addReviewers(prId: number, reviewers: string[]): Promise<void>;
export declare function deleteLabel(): never;
export declare function ensureComment({ number, topic, content, }: EnsureCommentConfig): Promise<boolean>;
export declare function ensureCommentRemoval(deleteConfig: EnsureCommentRemovalConfig): Promise<void>;
export declare function createPr({ sourceBranch, targetBranch, prTitle: title, prBody: description, platformPrOptions, }: CreatePRConfig): Promise<Pr>;
export declare function updatePr({ number: prNo, prTitle: title, prBody: description, state, targetBranch, }: UpdatePrConfig): Promise<void>;
export declare function mergePr({ branchName, id: prNo, strategy: mergeStrategy, }: MergePRConfig): Promise<boolean>;
