import type { HostRule } from '../../../types';
import type { GitOptions } from '../../../types/git';
import type { GitUrlOption } from '../types';
import type { BbsPr, BbsRestPr, BbsRestRepo, BitbucketError } from './types';
export declare const BITBUCKET_INVALID_REVIEWERS_EXCEPTION = "com.atlassian.bitbucket.pull.InvalidPullRequestReviewersException";
export declare function prInfo(pr: BbsRestPr): BbsPr;
export interface BitbucketCommitStatus {
    failed: number;
    inProgress: number;
    successful: number;
}
export type BitbucketBranchState = 'SUCCESSFUL' | 'FAILED' | 'INPROGRESS' | 'STOPPED';
export interface BitbucketStatus {
    key: string;
    state: BitbucketBranchState;
}
export declare function isInvalidReviewersResponse(err: BitbucketError): boolean;
export declare function getInvalidReviewers(err: BitbucketError): string[];
export declare function getRepoGitUrl(repository: string, defaultEndpoint: string, gitUrl: GitUrlOption | undefined, info: BbsRestRepo, opts: HostRule): string;
export declare function getExtraCloneOpts(opts: HostRule): GitOptions;
