"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PullRequestActivity = exports.PullRequestCommentActivity = exports.Comment = exports.Files = exports.UserSchema = void 0;
const zod_1 = require("zod");
exports.UserSchema = zod_1.z.object({
    displayName: zod_1.z.string(),
    emailAddress: zod_1.z.string(),
});
exports.Files = zod_1.z.array(zod_1.z.string());
exports.Comment = zod_1.z.object({
    text: zod_1.z.string(),
    id: zod_1.z.number(),
});
exports.PullRequestCommentActivity = zod_1.z.object({
    action: zod_1.z.literal('COMMENTED'),
    commentAction: zod_1.z.string(),
    comment: exports.Comment,
});
exports.PullRequestActivity = zod_1.z.union([
    zod_1.z.object({ action: zod_1.z.string() }),
    exports.PullRequestCommentActivity,
]);
//# sourceMappingURL=schema.js.map