import type { BitbucketServerHttp } from '../../../util/http/bitbucket-server';
import type { BbsPr } from './types';
export declare class BbsPrCache {
    private projectKey;
    private repo;
    private readonly ignorePrAuthor;
    private author;
    private cache;
    private items;
    private constructor();
    private static init;
    private getPrs;
    static getPrs(http: BitbucketServerHttp, projectKey: string, repo: string, ignorePrAuthor: boolean, author: string): Promise<BbsPr[]>;
    private setPr;
    static setPr(http: BitbucketServerHttp, projectKey: string, repo: string, ignorePrAuthor: boolean, author: string, item: BbsPr): Promise<void>;
    private reconcile;
    private sync;
    /**
     * Ensure the pr cache starts with the most recent PRs.
     * JavaScript ensures that the cache is sorted by PR number.
     */
    private updateItems;
}
