import type { BranchStatus } from '../../../types';
import type { BranchStatusConfig, CreatePRConfig, EnsureCommentConfig, EnsureCommentRemovalConfig, EnsureIssueConfig, EnsureIssueResult, FindPRConfig, Issue, MergePRConfig, PlatformParams, PlatformResult, Pr, RepoParams, RepoResult, UpdatePrConfig } from '../types';
import type { BbsPr } from './types';
export declare const id = "bitbucket-server";
export declare function initPlatform({ endpoint, token, username, password, gitAuthor, }: PlatformParams): Promise<PlatformResult>;
export declare function getRepos(): Promise<string[]>;
export declare function getRawFile(fileName: string, repoName?: string, branchOrTag?: string): Promise<string | null>;
export declare function getJsonFile(fileName: string, repoName?: string, branchOrTag?: string): Promise<any>;
export declare function initRepo({ repository, cloneSubmodules, cloneSubmodulesFilter, ignorePrAuthor, gitUrl, }: RepoParams): Promise<RepoResult>;
export declare function getBranchForceRebase(_branchName: string): Promise<boolean>;
export declare function getPr(prNo: number, refreshCache?: boolean): Promise<BbsPr | null>;
export declare function getPrList(): Promise<Pr[]>;
export declare function findPr({ branchName, prTitle, state, includeOtherAuthors, }: FindPRConfig): Promise<Pr | null>;
export declare function getBranchPr(branchName: string): Promise<BbsPr | null>;
export declare function refreshPr(number: number): Promise<void>;
export declare function getBranchStatus(branchName: string): Promise<BranchStatus>;
export declare function getBranchStatusCheck(branchName: string, context: string): Promise<BranchStatus | null>;
export declare function setBranchStatus({ branchName, context, description, state, url: targetUrl, }: BranchStatusConfig): Promise<void>;
export declare function findIssue(title: string): Promise<Issue | null>;
export declare function ensureIssue({ title, }: EnsureIssueConfig): Promise<EnsureIssueResult | null>;
export declare function getIssueList(): Promise<Issue[]>;
export declare function ensureIssueClosing(title: string): Promise<void>;
export declare function addAssignees(iid: number, assignees: string[]): Promise<void>;
export declare function addReviewers(prNo: number, reviewers: string[]): Promise<void>;
export declare function deleteLabel(issueNo: number, label: string): Promise<void>;
export declare function ensureComment({ number, topic, content, }: EnsureCommentConfig): Promise<boolean>;
export declare function ensureCommentRemoval(deleteConfig: EnsureCommentRemovalConfig): Promise<void>;
export declare function createPr({ sourceBranch, targetBranch, prTitle: title, prBody: rawDescription, platformPrOptions, }: CreatePRConfig): Promise<Pr>;
export declare function updatePr({ number: prNo, prTitle: title, prBody: rawDescription, state, bitbucketInvalidReviewers, targetBranch, }: UpdatePrConfig & {
    bitbucketInvalidReviewers?: string[] | undefined;
}): Promise<void>;
export declare function mergePr({ branchName, id: prNo, }: MergePRConfig): Promise<boolean>;
export declare function massageMarkdown(input: string): string;
export declare function maxBodyLength(): number;
