"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractPackageFile = extractPackageFile;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const logger_1 = require("../../../logger");
const yaml_1 = require("../../../util/yaml");
const extract_1 = require("../dockerfile/extract");
function woodpeckerVersionDecider(woodpeckerConfig) {
    const keys = ['clone', 'steps', 'pipeline', 'services'];
    return Object.keys(woodpeckerConfig).filter((key) => keys.includes(key));
}
function extractPackageFile(content, packageFile, extractConfig) {
    logger_1.logger.debug('woodpecker.extractPackageFile()');
    let config;
    try {
        // TODO: use schema (#9610)
        config = (0, yaml_1.parseSingleYaml)(content);
        if (!config) {
            logger_1.logger.debug({ packageFile }, 'Null config when parsing Woodpecker Configuration content');
            return null;
        }
        if (typeof config !== 'object') {
            logger_1.logger.debug({ packageFile, type: typeof config }, 'Unexpected type for Woodpecker Configuration content');
            return null;
        }
    }
    catch (err) {
        logger_1.logger.debug({ packageFile, err }, 'Error parsing Woodpecker Configuration config YAML');
        return null;
    }
    const pipelineKeys = woodpeckerVersionDecider(config);
    if (pipelineKeys.length === 0) {
        logger_1.logger.debug({ packageFile }, "Couldn't identify dependencies");
        return null;
    }
    // Image name/tags for services are only eligible for update if they don't
    // use variables and if the image is not built locally
    const deps = pipelineKeys.flatMap((pipelineKey) => Object.values(config[pipelineKey] ?? {})
        .filter((step) => is_1.default.string(step?.image))
        .map((step) => (0, extract_1.getDep)(step.image, true, extractConfig.registryAliases)));
    logger_1.logger.trace({ deps }, 'Woodpecker Configuration image');
    return deps.length ? { deps } : null;
}
//# sourceMappingURL=extract.js.map