"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportedDatasources = exports.defaultConfig = exports.url = exports.displayName = exports.supportsLockFileMaintenance = exports.updateArtifacts = exports.extractPackageFile = void 0;
const docker_1 = require("../../datasource/docker");
const helm_1 = require("../../datasource/helm");
var extract_1 = require("./extract");
Object.defineProperty(exports, "extractPackageFile", { enumerable: true, get: function () { return extract_1.extractPackageFile; } });
var artifacts_1 = require("./artifacts");
Object.defineProperty(exports, "updateArtifacts", { enumerable: true, get: function () { return artifacts_1.updateArtifacts; } });
exports.supportsLockFileMaintenance = true;
exports.displayName = 'vendir';
exports.url = 'https://carvel.dev/vendir/docs/latest';
exports.defaultConfig = {
    commitMessageTopic: 'vendir {{depName}}',
    managerFilePatterns: ['/(^|/)vendir\\.yml$/'],
};
exports.supportedDatasources = [helm_1.HelmDatasource.id, docker_1.DockerDatasource.id];
//# sourceMappingURL=index.js.map