import type { ExtractConfig, PackageDependency, PackageFileContent } from '../types';
import type { GitRefDefinition, GithubReleaseDefinition, HelmChartDefinition, VendirDefinition } from './schema';
export declare function extractHelmChart(helmChart: HelmChartDefinition, aliases?: Record<string, string>): PackageDependency | null;
export declare function extractGitSource(gitSource: GitRefDefinition): PackageDependency | null;
export declare function extractGithubReleaseSource(githubRelease: GithubReleaseDefinition): PackageDependency | null;
export declare function parseVendir(content: string, packageFile?: string): VendirDefinition | null;
export declare function extractPackageFile(content: string, packageFile: string, config: ExtractConfig): PackageFileContent | null;
