"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractPackageFile = extractPackageFile;
const logger_1 = require("../../../logger");
const array_1 = require("../../../util/array");
const yaml_1 = require("../../../util/yaml");
const extract_1 = require("../dockerfile/extract");
function extractPackageFile(file, packageFile) {
    let doc;
    try {
        // TODO: use schema (#9610)
        doc = (0, yaml_1.parseSingleYaml)(file);
    }
    catch (err) {
        logger_1.logger.debug({ err, packageFile }, 'Failed to parse Vela file.');
        return null;
    }
    const deps = [];
    // iterate over steps
    for (const step of (0, array_1.coerceArray)(doc.steps)) {
        const dep = (0, extract_1.getDep)(step.image);
        deps.push(dep);
    }
    // iterate over services
    for (const service of (0, array_1.coerceArray)(doc.services)) {
        const dep = (0, extract_1.getDep)(service.image);
        deps.push(dep);
    }
    // iterate over stages
    for (const stage of Object.values(doc.stages ?? {})) {
        for (const step of (0, array_1.coerceArray)(stage.steps)) {
            const dep = (0, extract_1.getDep)(step.image);
            deps.push(dep);
        }
    }
    // check secrets
    for (const secret of Object.values(doc.secrets ?? {})) {
        if (secret.origin) {
            const dep = (0, extract_1.getDep)(secret.origin.image);
            deps.push(dep);
        }
    }
    if (!deps.length) {
        return null;
    }
    return { deps };
}
//# sourceMappingURL=extract.js.map