"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.applyGitSource = applyGitSource;
const common_1 = require("../../util/common");
const url_1 = require("../../util/git/url");
const git_refs_1 = require("../datasource/git-refs");
const git_tags_1 = require("../datasource/git-tags");
const github_tags_1 = require("../datasource/github-tags");
const gitlab_tags_1 = require("../datasource/gitlab-tags");
function applyGitSource(dep, git, rev, tag, branch) {
    if (tag) {
        const platform = (0, common_1.detectPlatform)(git);
        if (platform === 'github' || platform === 'gitlab') {
            dep.datasource =
                platform === 'github'
                    ? github_tags_1.GithubTagsDatasource.id
                    : gitlab_tags_1.GitlabTagsDatasource.id;
            const { protocol, source, full_name } = (0, url_1.parseGitUrl)(git);
            dep.registryUrls = [`${protocol}://${source}`];
            dep.packageName = full_name;
        }
        else {
            dep.datasource = git_tags_1.GitTagsDatasource.id;
            dep.packageName = git;
        }
        dep.currentValue = tag;
        dep.skipReason = undefined;
    }
    else if (rev) {
        dep.datasource = git_refs_1.GitRefsDatasource.id;
        dep.packageName = git;
        dep.currentDigest = rev;
        dep.replaceString = rev;
        dep.skipReason = undefined;
    }
    else {
        dep.datasource = git_refs_1.GitRefsDatasource.id;
        dep.packageName = git;
        dep.currentValue = branch;
        dep.skipReason = branch ? 'git-dependency' : 'unspecified-version';
    }
}
//# sourceMappingURL=util.js.map