"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractPackageFile = extractPackageFile;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const logger_1 = require("../../../logger");
const yaml_1 = require("../../../util/yaml");
const node_version_1 = require("../../datasource/node-version");
function extractPackageFile(content, packageFile) {
    let doc;
    try {
        // TODO: use schema (#9610)
        doc = (0, yaml_1.parseSingleYaml)(content);
    }
    catch (err) {
        logger_1.logger.debug({ err, packageFile }, 'Failed to parse .travis.yml file.');
        return null;
    }
    let deps = [];
    if (doc && is_1.default.array(doc.node_js)) {
        deps = doc.node_js.map((currentValue) => ({
            depName: 'node',
            datasource: node_version_1.NodeVersionDatasource.id,
            currentValue: currentValue.toString(),
        }));
    }
    // Handle the matrix syntax
    let matrix_include;
    if (doc?.jobs?.include) {
        matrix_include = doc.jobs.include;
    }
    else if (doc?.matrix?.include) {
        matrix_include = doc.matrix.include;
    }
    if (!is_1.default.array(matrix_include)) {
        return deps.length ? { deps } : null;
    }
    for (const item of matrix_include) {
        if (item?.node_js) {
            if (is_1.default.array(item.node_js)) {
                item.node_js.forEach((currentValue) => {
                    deps.push({
                        depName: 'node',
                        datasource: node_version_1.NodeVersionDatasource.id,
                        currentValue: currentValue.toString(),
                    });
                });
            }
            else if (is_1.default.string(item.node_js)) {
                deps.push({
                    depName: 'node',
                    datasource: node_version_1.NodeVersionDatasource.id,
                    currentValue: item.node_js.toString(),
                });
            }
        }
    }
    if (!deps.length) {
        return null;
    }
    return { deps };
}
//# sourceMappingURL=extract.js.map