"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportedDatasources = exports.defaultConfig = exports.categories = exports.url = exports.displayName = exports.extractPackageFile = void 0;
const github_releases_1 = require("../../datasource/github-releases");
var extract_1 = require("./extract");
Object.defineProperty(exports, "extractPackageFile", { enumerable: true, get: function () { return extract_1.extractPackageFile; } });
exports.displayName = 'TFLint Plugins';
exports.url = 'https://github.com/terraform-linters/tflint/blob/master/docs/user-guide/plugins.md';
exports.categories = ['terraform'];
exports.defaultConfig = {
    commitMessageTopic: 'TFLint plugin {{depName}}',
    managerFilePatterns: ['/\\.tflint\\.hcl$/'],
    extractVersion: '^v(?<version>.*)$',
};
// Only from GitHub Releases: https://github.com/terraform-linters/tflint/blob/master/docs/developer-guide/plugins.md#4-creating-a-github-release
exports.supportedDatasources = [github_releases_1.GithubReleasesDatasource.id];
//# sourceMappingURL=index.js.map