"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractPackageFile = extractPackageFile;
const logger_1 = require("../../../logger");
const regex_1 = require("../../../util/regex");
const plugins_1 = require("./plugins");
const util_1 = require("./util");
const dependencyBlockExtractionRegex = (0, regex_1.regEx)(/^\s*plugin\s+"(?<pluginName>[^"]+)"\s+{\s*$/);
function extractPackageFile(content, packageFile, _config) {
    logger_1.logger.trace({ content }, `tflint.extractPackageFile(${packageFile})`);
    if (!(0, util_1.checkFileContainsPlugins)(content)) {
        logger_1.logger.debug({ packageFile }, 'preflight content check has not found any relevant content');
        return null;
    }
    let deps = [];
    try {
        const lines = content.split(regex_1.newlineRegex);
        for (let lineNumber = 0; lineNumber < lines.length; lineNumber += 1) {
            const line = lines[lineNumber];
            const tfLintPlugin = dependencyBlockExtractionRegex.exec(line);
            if (tfLintPlugin?.groups) {
                logger_1.logger.trace(`Matched TFLint plugin on line ${lineNumber}`);
                let result = null;
                result = (0, plugins_1.extractTFLintPlugin)(lineNumber, lines, tfLintPlugin.groups.pluginName);
                if (result) {
                    lineNumber = result.lineNumber;
                    deps = deps.concat(result.dependencies);
                    result = null;
                }
            }
        }
    }
    catch (err) /* istanbul ignore next */ {
        logger_1.logger.debug({ err, packageFile }, 'Error extracting TFLint plugins');
    }
    return deps.length ? { deps } : null;
}
//# sourceMappingURL=extract.js.map